﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

public class DebugMenu : MonoBehaviour
{
    public TMP_Text RPMText;
    public TMP_Text GearText;
    public TMP_Text SpeedGearText;

    private CarController _Controller;

    // Start is called before the first frame update
    void Start()
    {
        GameManager.Instance.PlayerCarChanged += OnPlayerCarChanged;
    }

    private void OnPlayerCarChanged(object sender, System.EventArgs e)
    {
        _Controller = GameManager.Instance.PlayerCarGameObject.GetComponent<CarController>();
    }

    // Update is called once per frame
    void Update()
    {
        RPMText.text = "RPM: " + _Controller.CurrentRPM.ToString();
        GearText.text = "Gear: " + _Controller.CurrentGear.ToString();
        SpeedGearText.text = "SG: " + _Controller.SpeedGearMax.ToString();
    }
}
